/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.bson;

import net.impactdev.impactor.relocations.org.bson.BsonBinaryReader;
import net.impactdev.impactor.relocations.org.bson.BsonType;
import net.impactdev.impactor.relocations.org.bson.BsonValue;
import net.impactdev.impactor.relocations.org.bson.RawBsonArray;
import net.impactdev.impactor.relocations.org.bson.RawBsonDocument;
import net.impactdev.impactor.relocations.org.bson.codecs.BsonValueCodecProvider;
import net.impactdev.impactor.relocations.org.bson.codecs.DecoderContext;
import net.impactdev.impactor.relocations.org.bson.codecs.configuration.CodecRegistries;
import net.impactdev.impactor.relocations.org.bson.codecs.configuration.CodecRegistry;
import net.impactdev.impactor.relocations.org.bson.io.BsonInputMark;

final class RawBsonValueHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());

    static BsonValue decode(byte[] bytes, BsonBinaryReader bsonReader) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT || bsonReader.getCurrentBsonType() == BsonType.ARRAY) {
            int position = bsonReader.getBsonInput().getPosition();
            BsonInputMark mark = bsonReader.getBsonInput().getMark(4);
            int size = bsonReader.getBsonInput().readInt32();
            mark.reset();
            bsonReader.skipValue();
            if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new RawBsonDocument(bytes, position, size);
            }
            return new RawBsonArray(bytes, position, size);
        }
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    private RawBsonValueHelper() {
    }
}

